function generateCaptcha() {
    var charset = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    var captchaLength = 6;
    var captcha = "";
    for (var i = 0; i < captchaLength; i++) {
        var randomIndex = Math.floor(Math.random() * charset.length);
        captcha += charset.charAt(randomIndex);
    }
    return captcha;
}

function displayCaptcha() {
    var captchatext = document.getElementById("captchaText");
    captchatext.textContent = generateCaptcha();
}

document.getElementById("generateBtn").addEventListener("click", function() {
    displayCaptcha();
    document.getElementById("captchaInput").value = "";
});

document.getElementById("submitBtn").addEventListener("click", function() {
    var captchaInput = document.getElementById("captchaInput").value;
    var captchaText = document.getElementById("captchaText").textContent;
    var messageContainer = document.getElementById("messageContainer");
    if (captchaInput === captchaText) {
        messageContainer.textContent = "CAPTCHA verification successful!";
        messageContainer.style.color = "green";

        displayCaptcha();
        document.getElementById("captchaInput").value = "";
    } else {
        messageContainer.textContent = "CAPTCHA verification failed. Please try again.";
        messageContainer.style.color = "red";

        displayCaptcha();
    }
});

displayCaptcha();