const gallery = document.getElementById("gallery");
const overlay = document.getElementById("overlay");
const overlayImg = document.getElementById("overlay-img");

const images = [
     "https://images.pexels.com/photos/1108099/pexels-photo-1108099.jpeg",
    "https://images.pexels.com/photos/842711/pexels-photo-842711.jpeg",
    "https://images.pexels.com/photos/414612/pexels-photo-414612.jpeg",
    "https://images.pexels.com/photos/34950/pexels-photo.jpg",
    "https://images.pexels.com/photos/730896/pexels-photo-730896.jpeg",
];

const heartPattern = [
    [0,1,1,0,0,0,1,1,0],
    [1,1,1,1,0,1,1,1,1],
    [1,1,1,1,1,1,1,1,1],
    [1,1,1,1,1,1,1,1,1],
    [0,1,1,1,1,1,1,1,0],
    [0,0,1,1,1,1,1,0,0],
    [0,0,0,1,1,1,0,0,0],
    [0,0,0,0,1,0,0,0,0],
];

let imgIndex = 0;
heartPattern.forEach(row => {
    row.forEach(cell => {
        if (cell === 1) {
            const div = document.createElement("div");
            div.className = "diamond";
            div.innerHTML = `<img src="${images[imgIndex % images.length]}" />`;
            div.addEventListener("click", () => {
                overlayImg.src = images[imgIndex % images.length];
                overlay.classList.add("active");
            });
            gallery.appendChild(div);
            imgIndex++;
        } else{
            const empty = document.createElement("div");
            empty.style.width = "80px";
            empty.style.height = "80px";
            gallery.appendChild(empty);
        }
    });
});

function closeOverlay() {
    overlay.classList.remove("active");
}
overlay.addEventListener("click", (e) => {
    if (e.target !== overlayImg) closeOverlay();
});

const canvas = document.getElementById("stars");
const ctx = canvas.getContext("2d");
let stars = [];
let w,h;
let mouseX = 0, mouseY = 0;

function resize() {
    w = canvas.width = window.innerWidth;
    h = canvas.height = window.innerHeight;
    stars = [];
    for (let i = 0; i < 200; i++) {
        stars.push({
            x: Math.random() * w,
            y: Math.random() * h,
            radius: Math.random() * 1.5,
            alpha: Math.random(),
            speed: Math.random() * 0.02 + 0.01
        
        });
    }
}

function draw() {
    ctx.clearRect(0, 0, w, h);
    ctx.fillStyle = "#fff";

    const offsetX = (mouseX - w/2) * 0.03;
    const offsetY = (mouseY - h/2) * 0.03;

    stars.forEach(star => {
        ctx.globalAlpha = star.alpha;
        ctx.beginPath();
        ctx.arc(star.x + offsetX, star.y + offsetY, star.radius, 0, Math.PI*2);
        ctx.fill();

        star.alpha += star.speed * (Math.random() > 0.5 ? 1 : -1);
        if (star.alpha <= 0) star.alpha = 0;
        if (star.alpha >= 1) star.alpha = 1;
    });

    requestAnimationFrame(draw);
}

    window.addEventListener("mousemove", e => {
        mouseX = e.clientX;
        mouseY = e.clientY;
    });

    window.addEventListener("resize", resize);
    resize();
    draw();



